# -*- coding: utf-8 -*-
# 発音辞書を利用して/k/で始まる単語の頻度表を作る

# c.txt を読み込んで発音のディクショナリを作る
pronunciation = {} # からっぽのディクショナリ（発音用）を用意

datafile = open('c.txt')
for line in datafile:

  line = line.rstrip()
  columns = line.split()

  word = columns[0]
  phonemes = columns[1:]

  pronunciation[word] = phonemes

# 頻度表の作成
freq = {} # からっぽのディクショナリ（頻度表用）を用意
datafile = open('h.txt')
for line in datafile:
  line = line.rstrip()
  words = line.split()

  # ディクショナリに頻度を反映させる
  for word in words:

    word = word.rstrip('.,!?') # 記号類の除去

    # 発音辞書に載っていなかったら飛ばす
    if not word.upper() in pronunciation:
      continue
    # 最初の音が 'K' でなかったら飛ばす
    elif not pronunciation[word.upper()][0] == 'K':
      continue

    if word in freq:
      freq[word] += 1
    else:
      freq[word] = 1

# ディクショナリの中身を表示
for word in freq:
  print(word + '\t' + str(freq[word]))