# -*- coding: utf-8 -*-
# 形態素解析結果を用いて単語の頻度表を作る

freq = {} # からっぽのディクショナリを用意
header = True # 見出し行あり

datafile = open('b2.txt', encoding='utf-8')
for line in datafile:

  # 見出し行をスキップ
  if header: 
    header = False
    continue

  line = line.rstrip()

  # EOS (End Of Sentence) の行は無視
  if line == 'EOS':
    continue

  columns = line.split('\t')
  base_form = columns[5] # 基本形を取り出す
  
  # 頻度のディクショナリに追加
  if base_form in freq:
    freq[base_form] += 1
  else:
    freq[base_form] = 1

# ディクショナリの中身を表示
for word in freq:
  print(word + '\t' + str(freq[word]))